#include "jeu.h"

#define TAILLE_PAQUET_MAX 1016

void envoyer_message(char *message, t_joueur joueur); //Envoie un message (d'erreur le plus souvent) au joueur
void lecture_message(long num, t_paquet *mess, t_reseau *res, t_affichage *aff); //Effectue l'affichage et la transmission des messages textes
long place_libre(long x, long y, long num, t_partie *jeu); //Place le pion num sur la premire case libre au tour de (x,y)
void deplacer_pion(long num, char *deplacement, t_partie *jeu, t_reseau *res); //Effectue le dplacement d'un pion
long pion_case(long x, long y, t_pion *pions, long nbr_pions); //Y a-t-il un pion sur la case (x, y) ? Non -> -1; Oui -> Numro du pion dans la liste
long graal_pion(long num, t_pion *pions, long nbr_pions); //Renvoie le numro du pion qui reprsente le graal du joueur num
void exploration(long dest_x, long dest_y, long dist, t_map *map, char **explore); //Actualise l'exploration du terrain
long charger_tileset(t_map *map, char *buffer); //Charge le tileset
void envoie_donnee(t_reseau *res, t_partie *jeu, long num); //Envoie les donnes ncessaires  l'initialisation d'une partieau joueur num
void traitement_version(t_affichage *aff, t_reseau *res, t_partie *jeu, long num, char *donnee); //Effectue le traitement des paquets VERSION
long resoudre_combat(t_partie *jeu, t_reseau *res); //Rsoud les combats du joueur qui vient de jouer
long combat(t_partie *jeu, t_reseau *res, long p1, long p2); //Effectue un combat entre 2 pions
long classer_ennemi(t_pion *pions, long ennemi[8], long nbr_ennemis, long num); //Classe les ennemis par ordre de combat et renvoie le nombre d'ennemis
void distribuer_graal(t_partie *jeu, t_reseau *res); //Distribue les graals aux pions proches
long choisir_slot(t_reseau *res, char *pseudo); //Slectionne le slot correspondant au pseudo
void swap_slot(t_reseau *res, long a, long b); //change les slots a et b
long test_victoire(t_partie *jeu, t_reseau *res, long num); //Effectue le test de vicoire pour le joueur num

long jeu_init(t_partie *jeu)
{
    jeu->jeu = 0; //A l'initialisation il n'y a pas de partie en cours
    jeu->tour = 0;
    jeu->deplacement = 0;
    jeu->nbr_pions_depart[GRAAL] = 1; //Nombre de pions de dpart par dfaut
    jeu->nbr_pions_depart[ECLAIREUR] = 2;
    jeu->nbr_pions_depart[PECORE] = 5;
    jeu->nbr_pions_depart[CHEVALIER] = 3;
    jeu->dist_inc = 1; //Visibilit par dfaut
    jeu->dist_vis = 2;
    jeu->nbr_pions = 0; //Pas encore de pion plac
    jeu->pions = NULL;
    jeu->map_chargee = 0; //Pas encore de map charge
    return 1;
}

void jeu_quit(t_reseau *res, t_partie *jeu)
{
    if(jeu->pions) {free(jeu->pions);}
    if(jeu->map_chargee) {supprimer_map(res, &(jeu->map));}
    return;
}

void traiter_paquets(t_affichage *aff, t_reseau *res, t_partie *jeu)
{
    t_paquet *temp_paquet; //Pointeur sur un paquet pour effacer
    char buffer[BUFFER_MAX]; //Tampon pour le texte format
    long i, j, k, temp; //Compteurs

    for(i = 0; i < res->nbr_joueurs; i++) //Pour chaque slot de joueur
    {
        while((res->joueurs[i].ecoute >= 0) && (res->joueurs[i].paquets->suivant != NULL)) //Tant qu'il y a des messages  traiter
        {
            //On supprime l'ancien paquet
            temp_paquet = res->joueurs[i].paquets;
            res->joueurs[i].paquets = res->joueurs[i].paquets->suivant;
            temp_paquet->suivant = NULL;
            supprimer_paquets(temp_paquet);
            //Et on traite le nouveau
            switch(res->joueurs[i].paquets->type)
            {
                case ERREUR_DECO: //S'il y a eu une erreur ou une dconnexion
                    supprimer_joueur(res, i); //On libre la mmoire inutilise
                    res->nbr_clients--;
                    sprintf(buffer, "Le joueur n%ld s'est dconnect !", i + 1);
                    afficher_message(aff->ecran, buffer, aff->police_normale, 255, 255, 0);
                    break;
                case MESSAGE:
                    lecture_message(i + 1, res->joueurs[i].paquets, res, aff);
                    break;
                case VERSION:
                    traitement_version(aff, res, jeu, i + 1, res->joueurs[i].paquets->donnee);
                    break;
                case TOUR:
                    if(jeu->jeu == 1)
                    {
                        if(i + 1 == jeu->tour) //Si c'est bien le tour de celui qui demande  changer
                        {
                            test_campeur(res, jeu, jeu->tour);
                            resoudre_combat(jeu, res);
                            distribuer_graal(jeu, res);
                            //Test de victoire
                            temp = 0;
                            for(j = 1; j <= res->nbr_joueurs; j++)
                            {
                                k = test_victoire(jeu, res, j);
                                if(k)
                                {
                                    SDLNet_Write32(j, buffer);
                                    SDLNet_Write32(k, buffer + 4);
                                    for(k = 0; k < res->nbr_joueurs; k++) {communiquer(VICTOIRE, 8, buffer, res->joueurs[k]);}
                                    jeu->jeu = -1;
                                    temp = 1;
                                }
                            }
                            if(temp == 0) //Si pas de victoire -> tour suivant
                            {
                                jeu->tour = jeu->tour % res->nbr_joueurs + 1;
                                recharger_pts(jeu->pions, jeu->nbr_pions, jeu->tour); //Recharger les points de mouvements
                                for(k = 0; k < jeu->nbr_pions; k++)
                                {
                                    SDLNet_Write32(k, buffer);
                                    SDLNet_Write32(jeu->pions[k].pts, buffer + 4);
                                    for(j = 0; j < res->nbr_joueurs; j++) {communiquer(PTS_MVT, 8, buffer, res->joueurs[j]);}
                                }
                                SDLNet_Write32(jeu->tour, buffer);
                                for(k = 0; k < res->nbr_joueurs; k++) {communiquer(TOUR, 4, buffer, res->joueurs[k]);}
                                jeu->deplacement = 0;
                                res->joueurs[jeu->tour - 1].campeur = 0;
                                test_campeur(res, jeu, jeu->tour); //On avertit le joeur d'enlever ses pions campeurs
                            }
                        }
                        else {envoyer_message("Ce n'est pas votre tour.", res->joueurs[i]);}
                    }
                    else
                    {
                        if(jeu->jeu == 0) {envoyer_message("Tous les joueurs ne sont pas encore connects.", res->joueurs[i]);}
                        else if(jeu->jeu == 2) {envoyer_message("La partie est en pause (attente de reconnexion).", res->joueurs[i]);}
                        else {envoyer_message("La partie est termine !", res->joueurs[i]);}
                    }
                    break;
                case DEPLACEMENT:
                    if(jeu->jeu == 1) {deplacer_pion(i + 1, res->joueurs[i].paquets->donnee, jeu, res);} //Si la partie est lance alors on peut s'occuper du dplacement des pions
                    else
                    {
                        if(jeu->jeu == 0) {envoyer_message("Tous les joueurs ne sont pas encore connects.", res->joueurs[i]);}
                        else if(jeu->jeu == 2) {envoyer_message("La partie est en pause (attente de reconnexion).", res->joueurs[i]);}
                        else {envoyer_message("La partie est termine !", res->joueurs[i]);}
                    }
                    break;
                case SAUVEGARDE:
                    if(jeu->jeu == 1 || jeu->jeu == 2)
                    {
                        if(!sauvegarder(aff, res, jeu, res->joueurs[i].paquets->donnee)) {envoyer_message("Impossible de sauvegarder !", res->joueurs[i]);}
                        else {envoyer_message("Sauvegarde russie !", res->joueurs[i]);}
                    }
                    else {envoyer_message("Vous ne pouvez pas sauvegardez maintenant !", res->joueurs[i]);}
                    break;
                default: //Dans tous les autres cas, on affiche une erreur
                    sprintf(buffer, "Le joueur n%ld a envoy un paquet de type inconnu !", i + 1);
                    afficher_message(aff->ecran, buffer, aff->police_normale, 255, 0, 0);
                    break;
            }
        }
        if(res->joueurs[i].ecoute == 0) //S'il vient de se dconnecter, on nettoie son slot
        {
            supprimer_joueur(res, i); //On libre la mmoire inutilise
            res->nbr_clients--;
            sprintf(buffer, "Le joueur n%ld s'est dconnect (erreur client) !", i + 1);
            afficher_message(aff->ecran, buffer, aff->police_normale, 255, 0, 0);
        }
    }
    return;
}

void envoyer_message(char *message, t_joueur joueur)
{
    char buffer[BUFFER_MAX + 4]; //Tampon du message

    SDLNet_Write32(0, buffer); //Le serveur est l'expditeur
    strcpy(buffer + 4, message); //On recopie le message  envoyer
    communiquer(MESSAGE, strlen(message) + 5, buffer, joueur); //On l'envoie
    return;
}

void lecture_message(long num, t_paquet *mess, t_reseau *res, t_affichage *aff)
{
    long destinataire;
    char buffer[BUFFER_MAX + 4];

    destinataire = SDLNet_Read32(mess->donnee); //On rcupre le destinataire
    SDLNet_Write32(num, mess->donnee); //On crit  la place l'expditeur pour la transmission
    if(destinataire <= res->nbr_joueurs) //Si le numro du destinataire correspond bien  un joueur
    {
        if(destinataire == -1)
        {
            for(destinataire = 0; destinataire < res->nbr_joueurs; destinataire++) //Pour chaque slot de joueur
            {
                communiquer(MESSAGE, mess->taille, mess->donnee, res->joueurs[destinataire]); //Si le joueur est bien connect, transmission du message
            }
            sprintf(buffer, "n%ld => Tous : %s", num, mess->donnee + 4);
            afficher_message(aff->ecran, buffer, aff->police_normale, 100, 100, 255);
        }
        else if(destinataire == 0)
        {
            envoyer_message("Message reu.", res->joueurs[num - 1]); //On signal  l'expditeur que son message  t reu
            sprintf(buffer, "n%ld => S : %s", num, mess->donnee + 4);
            afficher_message(aff->ecran, buffer, aff->police_normale, 100, 100, 255);
        }
        else
        {
            destinataire--; //Le destinaire est maintenant un index de tableau
            if(res->joueurs[destinataire].ecoute == 1) //Si le joueur est bien connect
            {
                communiquer(MESSAGE, mess->taille, mess->donnee, res->joueurs[destinataire]); //Transmission du message
                envoyer_message("Message transmis.", res->joueurs[num - 1]); //On signal  l'expditeur que son message a t transmis
                sprintf(buffer, "n%ld => n%ld : %s", num, destinataire + 1, mess->donnee + 4);
                afficher_message(aff->ecran, buffer, aff->police_normale, 100, 100, 255);
            }
            else //Si le joueur n'est pas connect
            {
                envoyer_message("Destinataire non connect.", res->joueurs[num - 1]); //On signal  l'expditeur que son message ne peut tre transmis
            }
        }
    }
    else //Si le joueur n'est pas valide
    {
        envoyer_message("Destinataire non valide.", res->joueurs[num - 1]); //On signal  l'expditeur que son message ne peut tre transmis
    }
    return;
}

long initialiser_pions(t_reseau *res, t_partie *jeu)
{
    long n, q; //Compteurs

    if(jeu->pions) {free(jeu->pions);}
    if(jeu->nbr_pions_depart[GRAAL]) {jeu->nbr_pions = 1;}
    else {jeu->nbr_pions = 0;}
    jeu->nbr_pions = (jeu->nbr_pions + jeu->nbr_pions_depart[ECLAIREUR] + jeu->nbr_pions_depart[PECORE] + jeu->nbr_pions_depart[CHEVALIER]) * res->nbr_joueurs;
    jeu->pions = (t_pion *)malloc(jeu->nbr_pions * sizeof(t_pion));
    if(!jeu->pions) {return 0;}

    jeu->nbr_pions = 0;
    for(n = 0; n < res->nbr_joueurs; n++)
    {
        if(jeu->nbr_pions_depart[GRAAL])
        {
            jeu->pions[jeu->nbr_pions].joueur = n; //Joueur qui possde le pion
            jeu->pions[jeu->nbr_pions].type = GRAAL; //Son type
            jeu->pions[jeu->nbr_pions].pos_x = res->joueurs[n].x; //Position de dpart
            jeu->pions[jeu->nbr_pions].pos_y = res->joueurs[n].y;
            jeu->pions[jeu->nbr_pions].pts = 0; //Ses points de dplacement restants
            jeu->pions[jeu->nbr_pions].pts_max = 0; //Maximum
            jeu->pions[jeu->nbr_pions].graal = 0; //L'unit ne porte pas le graal
            jeu->pions[jeu->nbr_pions].deplace = 0; //L'unit n'a pas t dplace
            jeu->nbr_pions++; //Pion suivant !
        }
        for(q = 0; q < jeu->nbr_pions_depart[CHEVALIER]; q++)
        {
            jeu->pions[jeu->nbr_pions].joueur = n; //Joueur qui possde le pion
            jeu->pions[jeu->nbr_pions].type = CHEVALIER; //Son type
            jeu->pions[jeu->nbr_pions].pos_x = res->joueurs[n].x; //Position de dpart (temporaire)
            jeu->pions[jeu->nbr_pions].pos_y = res->joueurs[n].y;
            jeu->pions[jeu->nbr_pions].pts = 0; //Ses points de dplacement restants
            jeu->pions[jeu->nbr_pions].pts_max = 2; //Maximum
            jeu->pions[jeu->nbr_pions].graal = 0; //L'unit ne porte pas le graal
            jeu->pions[jeu->nbr_pions].deplace = 0; //L'unit n'a pas t dplace
            if(!place_libre(res->joueurs[n].x, res->joueurs[n].y, jeu->nbr_pions, jeu))
            {
                free(jeu->pions);
                return 0;
            }
            jeu->nbr_pions++; //Pion suivant !
        }
        for(q = 0; q < jeu->nbr_pions_depart[PECORE]; q++)
        {
            jeu->pions[jeu->nbr_pions].joueur = n; //Joueur qui possde le pion
            jeu->pions[jeu->nbr_pions].type = PECORE; //Son type
            jeu->pions[jeu->nbr_pions].pos_x = res->joueurs[n].x; //Position de dpart (temporaire)
            jeu->pions[jeu->nbr_pions].pos_y = res->joueurs[n].y;
            jeu->pions[jeu->nbr_pions].pts = 0; //Ses points de dplacement restants
            jeu->pions[jeu->nbr_pions].pts_max = 3; //Maximum
            jeu->pions[jeu->nbr_pions].graal = 0; //L'unit ne porte pas le graal
            jeu->pions[jeu->nbr_pions].deplace = 0; //L'unit n'a pas t dplace
            if(!place_libre(res->joueurs[n].x, res->joueurs[n].y, jeu->nbr_pions, jeu))
            {
                free(jeu->pions);
                return 0;
            }
            jeu->nbr_pions++; //Pion suivant !
        }
        for(q = 0; q < jeu->nbr_pions_depart[ECLAIREUR]; q++)
        {
            jeu->pions[jeu->nbr_pions].joueur = n; //Joueur qui possde le pion
            jeu->pions[jeu->nbr_pions].type = ECLAIREUR; //Son type
            jeu->pions[jeu->nbr_pions].pos_x = res->joueurs[n].x; //Position de dpart (temporaire)
            jeu->pions[jeu->nbr_pions].pos_y = res->joueurs[n].y;
            jeu->pions[jeu->nbr_pions].pts = 0; //Ses points de dplacement restants
            jeu->pions[jeu->nbr_pions].pts_max = 5; //Maximum
            jeu->pions[jeu->nbr_pions].graal = 0; //L'unit ne porte pas le graal
            jeu->pions[jeu->nbr_pions].deplace = 0; //L'unit n'a pas t dplace
            if(!place_libre(res->joueurs[n].x, res->joueurs[n].y, jeu->nbr_pions, jeu))
            {
                free(jeu->pions);
                return 0;
            }
            jeu->nbr_pions++; //Pion suivant !
        }
    }
    for(q = 0; q < jeu->nbr_pions; q++) {exploration(jeu->pions[q].pos_x, jeu->pions[q].pos_y, jeu->dist_inc, &(jeu->map), res->joueurs[jeu->pions[q].joueur].explore);}
    return 1;
}

long place_libre(long x, long y, long num, t_partie *jeu)
{
    long i, j, n; //Compteurs
    long *libre_x, *libre_y, libre;

    n = 1;
    while(n < jeu->map.hauteur &&  n < jeu->map.largeur) //Tant qu'on a un champ de recherche raisonable
    {
        libre_x = (long *)malloc((4 * 2 * n + 1) * sizeof(long));
        libre_y = (long *)malloc((4 * 2 * n + 1) * sizeof(long));
        libre = 0;
        //Pour chaque case au tour de (x,y)
        for(i = y - n; i <= y + n; i++)
        {
            if(i >= 0 && i < jeu->map.hauteur)
            {
                for(j = x - n; j <= x + n; j++)
                {
                    if(j >= 0 && j < jeu->map.largeur && pion_case(j, i, jeu->pions, jeu->nbr_pions) == -1 && jeu->map.tiles[jeu->map.cases[i][j]].type == SOL) //Si la case d'arrive est libre et franchissable (non mortelle...)
                    {
                        libre_x[libre] = j;
                        libre_y[libre] = i;
                        libre++;
                    }
                }
            }
        }
        if(libre) //Si au moins 1 place libre
        {
            libre = rand() % libre;
            jeu->pions[num].pos_x = libre_x[libre];
            jeu->pions[num].pos_y = libre_y[libre];
            free(libre_x);
            free(libre_y);
            return 1; //On a pu placer le pion
        }
        else {n++;} //On largie le champ de recherche ( optimiser car on refait les tests non concluants...)
        free(libre_x);
        free(libre_y);
    }
    return 0; //Impossible de placer le pion sur la map
}

void reculer(t_reseau *res, t_partie *jeu, long num)
{
    long x, y, dx, dy, temp;
    float coscarre;

    //Rcupration de la case de destination selon les exigences du sujet
    temp = graal_pion(jeu->pions[num].joueur + 1, jeu->pions, jeu->nbr_pions);
    x = jeu->pions[num].pos_x - jeu->pions[temp].pos_x;
    if(x != 0) {dx = abs((int) x) / x;}
    else {dx = 0;}
    y = jeu->pions[num].pos_y - jeu->pions[temp].pos_y;
    if(y != 0) {dy = abs((int) y) / y;}
    else {dy = 0;}
    coscarre = (float) (x * x) / (x * x + y * y); //(Dtermine la case "la plus aligne" avec la position de dpart et le graal)
    if(coscarre <= 0.1) {dx = 0;}
    else if(coscarre >= 0.9) {dy = 0;}
    if(pion_case(jeu->pions[num].pos_x - dx, jeu->pions[num].pos_y - dy, jeu->pions, jeu->nbr_pions) == -1) //Inutile de vrifier si les coordonnes sont dans la map : si ce n'est pas le cas la fonction retourne -1
    {
        jeu->pions[num].pos_x = jeu->pions[num].pos_x - dx;
        jeu->pions[num].pos_y = jeu->pions[num].pos_y - dy;
    }
    else {place_libre(res->joueurs[jeu->pions[num].joueur].x, res->joueurs[jeu->pions[num].joueur].y, num, jeu);} //Si la case est dj occupe : retour au dpart
}

void deplacer_pion(long num, char *deplacement, t_partie *jeu, t_reseau *res)
{
    char buffer[BUFFER_MAX];
    long num_pion; //Numro du pion  dplacer
    long dest_x, dest_y; //Position de destination
    long i, temp;

    num_pion = SDLNet_Read32(deplacement);
    dest_x = SDLNet_Read32(deplacement + 4);
    dest_y = SDLNet_Read32(deplacement + 8);
    if(num == jeu->tour) //Si c'est bien le tour du joueur qui demande le dplacement
    {
        if(num_pion < jeu->nbr_pions) //Si le pion demand est bien un pion !
        {
            if(jeu->pions[num_pion].joueur == num - 1) //Si le pion demand appartient bien au joueur qui veut le dplac
            {
                if(dest_x >= 0 && dest_x < jeu->map.largeur && dest_y >= 0 && dest_y < jeu->map.hauteur) //Si les coordonnes sont bien dans la map
                {
                    if(jeu->map.tiles[jeu->map.cases[dest_y][dest_x]].type == SOL || jeu->map.tiles[jeu->map.cases[dest_y][dest_x]].type == MORTEL) //Si la case d'arrive est franchissable
                    {
                        if(jeu->pions[num_pion].pos_x == dest_x && jeu->pions[num_pion].pos_y == dest_y) {} //S'il n'y a pas de dplacement, on ignore la demande
                        else if(pion_case(dest_x, dest_y, jeu->pions, jeu->nbr_pions) == -1) //Si la case d'arrive est libre
                        {
                            if((-1 <= jeu->pions[num_pion].pos_x - dest_x) && (jeu->pions[num_pion].pos_x - dest_x <= 1) && (-1 <= jeu->pions[num_pion].pos_y - dest_y) && (jeu->pions[num_pion].pos_y - dest_y <= 1)) //Si le dplacement n'est que d'une case
                            {
                                if(jeu->pions[num_pion].pts_max != 0) //Si le pion est une unit dplaable
                                {
                                    if(jeu->pions[num_pion].deplace == 0 || jeu->pions[num_pion].deplace == jeu->deplacement) //Si le pion ne s'est pas encore dplace ou n'a pas fini son dplacement
                                    {
                                        //Si le pion peut partir de la case
                                        if(((jeu->map.tiles[jeu->map.cases[jeu->pions[num_pion].pos_y][jeu->pions[num_pion].pos_x]].cout_pts > 0)
                                                && (jeu->pions[num_pion].pts >= jeu->map.tiles[jeu->map.cases[jeu->pions[num_pion].pos_y][jeu->pions[num_pion].pos_x]].cout_pts))
                                            || ((jeu->map.tiles[jeu->map.cases[jeu->pions[num_pion].pos_y][jeu->pions[num_pion].pos_x]].cout_pts == 0)
                                                && (jeu->pions[num_pion].pts == jeu->pions[num_pion].pts_max)))
                                        {
                                            //On enlve le cot du dplacement
                                            if(jeu->map.tiles[jeu->map.cases[jeu->pions[num_pion].pos_y][jeu->pions[num_pion].pos_x]].cout_pts == 0) {jeu->pions[num_pion].pts = 0;}
                                            else {jeu->pions[num_pion].pts -= jeu->map.tiles[jeu->map.cases[jeu->pions[num_pion].pos_y][jeu->pions[num_pion].pos_x]].cout_pts;}
                                            jeu->pions[num_pion].pos_x = dest_x; //On actualise les coordonnes du pion
                                            jeu->pions[num_pion].pos_y = dest_y;
                                            if(jeu->pions[num_pion].deplace == 0) {jeu->deplacement++;} //Si l'unit ne s'tait pas dplace alors il y a un dplacement de plus
                                            jeu->pions[num_pion].deplace = jeu->deplacement; //L'unit est la 'jeu->deplacement'me  s'tre dplace
                                            SDLNet_Write32(num_pion, buffer);
                                            SDLNet_Write32(jeu->pions[num_pion].pts, buffer + 4);
                                            for(i = 0; i < res->nbr_joueurs; i++)
                                            {
                                                communiquer(DEPLACEMENT, 12, deplacement, res->joueurs[i]);
                                                communiquer(PTS_MVT, 8, buffer, res->joueurs[i]);
                                            }
                                            exploration(dest_x, dest_y, jeu->dist_inc, &(jeu->map), res->joueurs[jeu->pions[num_pion].joueur].explore); //On actualise la partie explore par le joueur
                                            if(jeu->pions[num_pion].graal) //Si ce pion porte un graal
                                            {
                                                temp = graal_pion(jeu->pions[num_pion].graal, jeu->pions, jeu->nbr_pions);
                                                jeu->pions[temp].pos_x = dest_x;
                                                jeu->pions[temp].pos_y = dest_y;
                                                SDLNet_Write32(temp, deplacement);
                                                for(i = 0; i < res->nbr_joueurs; i++) {communiquer(DEPLACEMENT, 12, deplacement, res->joueurs[i]);}
                                                exploration(dest_x, dest_y, jeu->dist_inc, &(jeu->map), res->joueurs[jeu->pions[temp].joueur].explore);
                                            }
                                        }
                                        else {envoyer_message("Plus assez de points de mouvement !", res->joueurs[num - 1]);} //Plus assez de points de dplacement
                                    }
                                    else {envoyer_message("Cette unit ne peut plus se dplacer pour ce tour !", res->joueurs[num - 1]);} //L'unit a dj t dplace
                                }
                                else {envoyer_message("Cette unit ne peut pas se dplacer !", res->joueurs[num - 1]);} //Sinon l'unit est fixe (graal, btiment, etc.)
                            }
                            else {envoyer_message("Vous ne pouvez vous dplacer que d'une case  la fois !", res->joueurs[num - 1]);} //Une seule case  la fois !
                        }
                        else {envoyer_message("Vous ne pouvez pas vous dplacer sur une case occupe !", res->joueurs[num - 1]);} //Case non vide
                    }
                    else {envoyer_message("Vous ne pouvez pas vous dplacer sur une telle case !", res->joueurs[num - 1]);} //Sinon elle est infranchissable
                }
                else {envoyer_message("Les coordonnes de dplacement ne sont pas sur la carte !", res->joueurs[num - 1]);} //Coordonnes errones
            }
            else {envoyer_message("Vous ne pouvez pas dplacer un pion qui ne vous appartient pas !", res->joueurs[num - 1]);} //Ce pion ne lui appartient pas
        }
        else {envoyer_message("Erreur : le pion  dplacer n'existe pas !", res->joueurs[num - 1]);} //Erreur de communication du numro du pion
    }
    else {envoyer_message("Ce n'est pas encore votre tour !", res->joueurs[num - 1]);} //Ce n'est pas son tour
    return;
}

long pion_case(long x, long y, t_pion *pions, long nbr_pions)
{
    long i; //Compteur qui parcourt les pions

    for(i = 0; i < nbr_pions; i++) //Pour chaque pion de la liste
    {
        if(pions[i].pos_x == x && pions[i].pos_y == y && (pions[i].type != GRAAL || pions[i].graal == 0)) {return i;} //Si on a trouv le pion on le renvoie
    }
    return -1; //Sinon il n'y a pas de pion sur la case
}

long graal_pion(long num, t_pion *pions, long nbr_pions)
{
    long i; //Compteur qui parcourt les pions

    for(i = 0; i < nbr_pions; i++) //Pour chaque pion de la liste
    {
        if(pions[i].type == GRAAL && pions[i].joueur == num - 1) {return i;} //Si on a trouv le pion/graal on le renvoie
    }
    return -1; //Sinon il n'y a pas de pion/graal pour le joueur num
}

void exploration(long dest_x, long dest_y, long dist, t_map *map, char **explore)
{
    long i, j; //Compteurs

    for(i = dest_y - dist; i <= dest_y + dist; i++)
    {
        if(i >= 0 && i < map->hauteur)
        {
            for(j = dest_x - dist; j <= dest_x + dist; j++)
            {
                if(j >= 0 && j < map->largeur)
                {
                    if ((j - dest_x) * (j - dest_x) + (i - dest_y) * (i - dest_y) <= (dist * dist))
                    {
                        explore[i][j] = 1;
                    }
                }
            }
        }
    }
    return;
}

void recharger_pts(t_pion *pions, long nbr_pions, long num)
{
    long i;

    //Pour chaque pion
    for(i = 0; i < nbr_pions; i++)
    {
        if(pions[i].joueur == num - 1) //On recharge s'il appartient au joueur dsign
        {
            pions[i].pts = pions[i].pts_max;
            pions[i].deplace = 0;
        }
    }
}

long charger_map(t_reseau *res, t_map *map, char *fichier_nom, char *fichier_tile) //Version serveur
{
    FILE *fichier; // Pointeur sur le fichier .map  charger
    long n, x, y, tilemax; // Compteurs d'indice, de position, et nombre de tiles.
    char buffer[BUFFER_MAX]; // Contient la chaine de caractre d'indication du fichier map
    char c; // Contient l'octet prcdemment obtenu

    sprintf(buffer, "%s%s", MAPS_DIR, fichier_nom);
    fichier = fopen(buffer, "rb"); // On ouvre le fichier en LECTURE BINAIRE SEULE
    map->taille = 0;
    if(fichier) //Si le fichier est ouvert
    {
        fscanf(fichier,"%4s", buffer); // On rcupre les 4 premiers caractres
        buffer[4] = 0;
        if(strcmp("KMAP", buffer) == 0) // On verifie que le fichier commence bien par KMAP, preuve que le fichier est bien une map
        {
            map->taille += 4;
            /// CHARGEMENT DU TILESET
            // On dfinit le fichier du Tileset (la grille des diffrents terrains)
            n = 0;// On initialise le compteur d'indice
            do // Boucle Do...While pour capturer le nom du fichier
            {
                buffer[n] = fgetc(fichier); // On rcupre le caractre
            }while(buffer[n++] != 0); // Le caractre EOT permet de dfinir la fin du nom du fichier
            map->taille += n;

            //Chargement du tileset
            if(fichier_tile)
            {
                if(!charger_tileset(map, fichier_tile))
                {
                    fclose(fichier);
                    return 0;
                }
            }
            else
            {
                if(!charger_tileset(map, buffer))
                {
                    fclose(fichier);
                    return 0;
                }
            }

            tilemax = (long)fgetc(fichier); // L'octet suivant contient le nombre de tiles
            map->taille += 1;
            if(tilemax != map->tileset.largeur * map->tileset.hauteur) // Si le tileset ne contient pas le mme nombre de tiles que celles definies dans la map
            {
                fclose(fichier); // On ferme le fichier
                return 0;
            }

            // On alloue les tiles en fonction de la taille du Tileset
            map->tiles = (t_tile*)malloc(tilemax * sizeof(t_tile));
            if(!map->tiles)
            {
                fclose(fichier); // On ferme le fichier
                return 0;
            }
            for (n = 0; n < tilemax; n++) // On parcourt toutes les tiles
            {
                map->tiles[n].type = fgetc(fichier); // Le premier octet dfinit le type de terrain
                map->tiles[n].cout_pts = (long) fgetc(fichier); // L'octet suivant dfinit le cout en points de mouvement
                // Les 3 octets d'aprs dfinissent les composantes de la couleur de la tile dans la minimap
                fgetc(fichier); // D'abord le Rouge
                fgetc(fichier); // Puis le Vert
                fgetc(fichier); // Et enfin le Bleu

                map->taille += 5;
            }

            // La taille de la map est stocke sur 2 octets (255*255 max)
            map->largeur = fgetc(fichier); // 1 octet pour la Taille de la map en largeur
            map->hauteur = fgetc(fichier); // 1 octet pour la Taille de la map en hauteur
            map->taille += 2;

            // On initialise les cases de la map
            map->cases = (long **)malloc(map->hauteur * sizeof(long *)); // Allocation des pointeurs sur les lignes de cases
            if(!map->cases)
            {
                free(map->tiles); //On libre la mmoire alloue jusqu' maintenant
                fclose(fichier); // On ferme le fichier
                return 0;
            }
            // Les types de tile sont placs  la suite de gauche  droite, et de bas en haut
            for(y = 0; y < map->hauteur; y++) // On explore donc tout ligne par ligne
            {
                map->cases[y] = (long*)malloc(map->largeur * sizeof(long)); // Allocation des pointeurs sur les cases
                if(!map->cases[y])
                {
                    //On libre la mmoire alloue jusqu' maintenant
                    free(map->tiles);
                    for(x = 0; x < y; x++) {free(map->cases[x]);}
                    free(map->cases);
                    fclose(fichier); // On ferme le fichier
                    return 0;
                }
                for(x = 0; x < map->largeur; x++) //De gauche  droite
                {
                    map->cases[y][x] = (long) fgetc(fichier); // 1 octet pour le type de tile de la case
                }
            }
            map->taille += map->hauteur * map->largeur;

            c = fgetc(fichier); // Rcupration du caractre sens tre le dernier
            if(!feof(fichier)) // Si ce caractre n'tait pas le caractre EOF
            {
                //On libre la mmoire alloue jusqu' maintenant
                free(map->tiles);
                for(n = 0; n < map->hauteur; n++) {free(map->cases[n]);}
                free(map->cases);
                fclose(fichier); // On ferme le fichier
                return 0;
            }

            rewind(fichier);
            map->fichier = (char *)malloc(map->taille);
            if(!map->fichier)
            {
                //On libre la mmoire alloue jusqu' maintenant
                free(map->tiles);
                for(n = 0; n < map->hauteur; n++) {free(map->cases[n]);}
                free(map->cases);
                fclose(fichier); // On ferme le fichier
                return 0;
            }
            fread(map->fichier, 1, map->taille, fichier);
            fclose(fichier); // On ferme le fichier

            //On compte le nombre de joueurs pour la map
            n = 0;
            for(y = 0; y < map->hauteur; y++) // On explore donc tout ligne par ligne
            {
                for(x = 0; x < map->largeur; x++) //De gauche  droite
                {
                    if(map->tiles[map->cases[y][x]].type == CAMP) {n++;}
                }
            }
            if(n <= 0 || n > 4 || !changer_nbr_joueurs(res, n)) //Si on arrive pas  allouer la mmoire pour les joueurs
            {
                //On libre la mmoire alloue jusqu' maintenant
                free(map->tiles);
                for(n = 0; n < map->hauteur; n++) {free(map->cases[n]);}
                free(map->cases);
                free(map->fichier);
                return 0;
            }
            //On place chaque joueur sur la map
            n = 0;
            for(y = 0; y < map->hauteur; y++) // On explore donc tout ligne par ligne
            {
                for(x = 0; x < map->largeur; x++) //De gauche  droite
                {
                    if(map->tiles[map->cases[y][x]].type == CAMP)
                    {
                        res->joueurs[n].x = x;
                        res->joueurs[n].y = y;
                        n++;
                    }
                }
            }
            for(n = 0; n < res->nbr_joueurs; n++)
            {
                res->joueurs[n].explore = (char **)malloc(map->hauteur * sizeof(char *));
                if(!res->joueurs[n].explore) //Si le malloc a chou
                {
                    free(map->tiles);
                    for(y = 0; y < map->hauteur; n++) {free(map->cases[y]);}
                    free(map->cases);
                    for(y = 0; y < n; y++)
                    {
                        for(x = 0; x < map->hauteur; x++)
                        {
                            free(res->joueurs[y].explore[x]);
                        }
                        free(res->joueurs[y].explore);
                    }
                    free(map->fichier);
                    return 0;
                }
                for(y = 0; y < map->hauteur; y++)
                {
                    res->joueurs[n].explore[y] = (char *)malloc(map->hauteur * sizeof(char));
                    if(!res->joueurs[n].explore[y]) //Si le malloc a chou
                    {
                        for(x = 0; x < y; x++) {free(res->joueurs[n].explore[x]);}
                        free(res->joueurs[n].explore);
                        free(map->tiles);
                        for(y = 0; y < map->hauteur; n++) {free(map->cases[y]);}
                        free(map->cases);
                        for(y = 0; y < n; y++)
                        {
                            for(x = 0; x < map->hauteur; x++)
                            {
                                free(res->joueurs[y].explore[x]);
                            }
                            free(res->joueurs[y].explore);
                        }
                        free(map->fichier);
                        return 0;
                    }
                    for(x = 0; x < map->hauteur; x++) {res->joueurs[n].explore[y][x] = 0;}
                }
            }
            return 1; //Tout c'est bien pass
        }
        else // Si les 4 permieres caractres ne sont pas "KMAP"
        {
            fclose(fichier); // On ferme le fichier
            return 0;
        }
    }
    else {return 0;} // Si le fichier n'a pas pu tre charg
}

long charger_tileset(t_map *map, char *buffer)
{
    SDL_Surface *image; // Surface du tileset
    FILE *f_tileset; // Pointeur sur le tileset .png
    char temp[BUFFER_MAX];

    sprintf(temp, "%s%s", RESSOURCES_DIR, buffer);
    image = (SDL_Surface *) IMG_Load(temp); // On charge l'image du tileset
    if(!image) {return 0;} //Si a rate
    // On dfinit la largeur et la hauteur du tileset
    map->tileset.largeur = image->w / TILE_TAILLE;// nombre de tiles en largeur
    map->tileset.hauteur = image->h / TILE_TAILLE;// nombre de tiles en hauteur
    SDL_FreeSurface(image); //Ct serveur on a plus besoin de l'image

    //Chargement des donnes du tileset
    f_tileset = fopen(temp, "rb"); // On ouvre le fichier en LECTURE BINAIRE SEULE
    if(!f_tileset) {return 0;} //Si a rate
    fseek(f_tileset, 0, SEEK_END); //On va  la fin du fichier
    map->tileset.taille = ftell(f_tileset); //On demande la position qui vaut donc la taille du fichier
    rewind(f_tileset); //On revient au dbut du fichier
    map->tileset.fichier = (char *)malloc(map->tileset.taille);
    if(!map->tileset.fichier) //Si a rate
    {
        fclose(f_tileset); //On ferme le tileset
        return 0;
    }
    fread(map->tileset.fichier, 1, map->tileset.taille, f_tileset); //On charge caractre par caractre
    fclose(f_tileset); //On a fini avec le tileset
    return 1;
}

void supprimer_map(t_reseau *res, t_map *map)
{
    long i, y;

    for(i = 0; i < res->nbr_joueurs; i++)
    {
        for(y = 0; y < map->hauteur; y++)
        {
            free(res->joueurs[i].explore[y]);
        }
        free(res->joueurs[i].explore);
    }

    free(map->tileset.fichier);
    free(map->tiles);
    for(i = 0; i < map->hauteur; i++)
    {
        free(map->cases[i]);
    }
    free(map->cases);
    free(map->fichier);
    return;
}

void envoie_donnee(t_reseau *res, t_partie *jeu, long num)
{
    char buffer[TAILLE_PAQUET_MAX];
    long i, j;

    SDLNet_Write32(res->nbr_joueurs, buffer);
    SDLNet_Write32(num, buffer + 4);
    SDLNet_Write32(jeu->dist_inc, buffer + 8);
    SDLNet_Write32(jeu->dist_vis, buffer + 12);
    communiquer(INFO, 16, buffer, res->joueurs[num - 1]); //Envoie des info

    //Envoie des donnes des autres joueurs
    for(i = 0; i < res->nbr_joueurs; i++)
    {
        SDLNet_Write32(i + 1, buffer);
        SDLNet_Write32(res->joueurs[i].x, buffer + 4);
        SDLNet_Write32(res->joueurs[i].y, buffer + 8);
        communiquer(BASE, 12, buffer, res->joueurs[num - 1]);
        if(res->pseudo[i])
        {
            strcpy(buffer + 4, res->pseudo[i]);
            communiquer(PSEUDO, strlen(buffer + 4) + 5, buffer, res->joueurs[num - 1]);
        }
    }

    //Envoie de la map (en petits paquets)
    j = jeu->map.taille / TAILLE_PAQUET_MAX;
    if(jeu->map.taille % TAILLE_PAQUET_MAX) {SDLNet_Write32(j + 1, buffer);}
    else {SDLNet_Write32(j, buffer);}
    communiquer(MAP, 4, buffer, res->joueurs[num - 1]); //Envoie du nombre de paquets  recevoir
    for(i = 0; i < j; i++)
    {
        memcpy(buffer, jeu->map.fichier + i * TAILLE_PAQUET_MAX, TAILLE_PAQUET_MAX);
        communiquer(MAP, TAILLE_PAQUET_MAX, buffer, res->joueurs[num - 1]);
    }
    i = jeu->map.taille % TAILLE_PAQUET_MAX;
    if(i)
    {
        memcpy(buffer, jeu->map.fichier + j * TAILLE_PAQUET_MAX, i);
        communiquer(MAP, i, buffer, res->joueurs[num - 1]);
    }
    //Envoie du tileset (en petits paquets)
    j = jeu->map.tileset.taille / TAILLE_PAQUET_MAX;
    if(jeu->map.tileset.taille % TAILLE_PAQUET_MAX) {SDLNet_Write32(j + 1, buffer);}
    else {SDLNet_Write32(j, buffer);}
    communiquer(TILESET, 4, buffer, res->joueurs[num - 1]); //Envoie du nombre de paquets  recevoir
    for(i = 0; i < j; i++)
    {
        memcpy(buffer, jeu->map.tileset.fichier + i * TAILLE_PAQUET_MAX, TAILLE_PAQUET_MAX);
        communiquer(TILESET, TAILLE_PAQUET_MAX, buffer, res->joueurs[num - 1]);
    }
    i = jeu->map.tileset.taille % TAILLE_PAQUET_MAX;
    if(i)
    {
        memcpy(buffer, jeu->map.tileset.fichier + j * TAILLE_PAQUET_MAX, i);
        communiquer(TILESET, i, buffer, res->joueurs[num - 1]);
    }

    //Envoie de tous les pions
    for(i = 0; i < jeu->nbr_pions; i++)
    {
        SDLNet_Write32(i, buffer);
        SDLNet_Write32(jeu->pions[i].joueur, buffer + 4);
        SDLNet_Write32(jeu->pions[i].type, buffer + 8);
        SDLNet_Write32(jeu->pions[i].pos_x, buffer + 12);
        SDLNet_Write32(jeu->pions[i].pos_y, buffer + 16);
        SDLNet_Write32(jeu->pions[i].graal, buffer + 20);
        SDLNet_Write32(jeu->pions[i].deplace, buffer + 24);
        buffer[28] = jeu->pions[i].pts;
        buffer[29] = jeu->pions[i].pts_max;
        communiquer(AJOUTER_PION, 30, buffer, res->joueurs[num - 1]);
    }

    //Envoie du terrain explor
    for(i = 0; i < jeu->map.hauteur; i++)
    {
        SDLNet_Write32(i, buffer); //On crit le numro de la ligne
        memcpy(buffer + 4, res->joueurs[num - 1].explore[i], jeu->map.largeur); //On crit chaque case de cette ligne
        communiquer(EXPLORE, jeu->map.largeur + 4, buffer, res->joueurs[num - 1]); //On envoie le tout
    }

    res->joueurs[num - 1].pret = 1;
    return;
}

void traitement_version(t_affichage *aff, t_reseau *res, t_partie *jeu, long num, char *donnee)
{
    char buffer[BUFFER_MAX]; //Tampon
    long temp; //Retient le slot choisi
    long i; //Compteur

    if(SDLNet_Read32(donnee) == (1 << 24 | 0 << 16 | 0 << 8 | 0)) //Si la version du client est bien 1.0.0.0
    {
        //change en fonction des pseudo
        if(donnee[4])
        {
            temp = choisir_slot(res, donnee + 4);
            if(temp) //Si on a un slot pour le joueur
            {
                if(res->joueurs[temp - 1].ecoute != -1 && temp != num) //Si le slot choisit est dj en coute d'un autre joueur
                {
                    envoyer_message("Votre pseudo est dj pris...", res->joueurs[num - 1]);
                    supprimer_joueur(res, num - 1); //On libre la mmoire inutilise
                    res->nbr_clients--;
                    sprintf(buffer, "Le joueur n%ld tente de se connecter sur un slot occup !", num);
                    afficher_message(aff->ecran, buffer, aff->police_normale, 255, 0, 0);
                    return;
                }
                swap_slot(res, num - 1, temp - 1);
                envoie_donnee(res, jeu, temp); //On peut alors lui envoyer les donnes

                //On range le nouveau pseudo
                if(res->pseudo[temp - 1] == NULL)
                {
                    res->pseudo[temp - 1] = (char *)malloc((strlen(donnee + 4) + 1) * sizeof(char));
                    if(res->pseudo[temp - 1] == NULL)
                    {
                        supprimer_joueur(res, temp - 1); //On libre la mmoire inutilise
                        res->nbr_clients--;
                        afficher_message(aff->ecran, "Impossible d'allouer la mmoire pour le nouveau joueur !", aff->police_normale, 255, 0, 0);
                        return;
                    }
                }
                strcpy(res->pseudo[temp - 1], donnee + 4);
                //On envoie le nom du nouveau joueur aux autres
                SDLNet_Write32(temp, buffer);
                strcpy(buffer + 4, res->pseudo[temp - 1]);
                for(i = 0; i < res->nbr_joueurs; i++)
                {
                    if(res->joueurs[i].ecoute == 1) {communiquer(PSEUDO, strlen(buffer + 4) + 5, buffer, res->joueurs[i]);}
                }
                sprintf(buffer, "Le joueur n%ld est maintenant le n%ld et s'appelle %s !", num, temp, res->pseudo[temp - 1]);
                afficher_message(aff->ecran, buffer, aff->police_normale, 0, 255, 0);
            }
            else
            {
                envoyer_message("Votre pseudo n'est pas prsent sur cette partie (ou dj pris) !", res->joueurs[num - 1]);
                supprimer_joueur(res, num - 1); //On libre la mmoire inutilise
                res->nbr_clients--;
                sprintf(buffer, "Le joueur n%ld utilise un pseudo inconnu (ou dj pris) pour cette partie !", num);
                afficher_message(aff->ecran, buffer, aff->police_normale, 255, 0, 0);
            }
        }
        else
        {
            envoyer_message("Votre pseudo n'est pas valide !", res->joueurs[num - 1]);
            supprimer_joueur(res, num - 1); //On libre la mmoire inutilise
            res->nbr_clients--;
            sprintf(buffer, "Le joueur n%ld utilise un pseudo non valide !", num);
            afficher_message(aff->ecran, buffer, aff->police_normale, 255, 0, 0);
        }
    }
    else //Si la version ne correspond pas, on le dconnecte
    {
        envoyer_message("Version du serveur diffrente !", res->joueurs[num - 1]);
        supprimer_joueur(res, num - 1); //On libre la mmoire inutilise
        res->nbr_clients--;
        sprintf(buffer, "Le joueur n%ld utilise une version diffrente !", num);
        afficher_message(aff->ecran, buffer, aff->police_normale, 255, 0, 0);
    }
    return;
}

long resoudre_combat(t_partie *jeu, t_reseau *res)
{
    long i, j, n;
    long x, y;
    long ennemi[8];
    long nbr_ennemis;
    long resul;

    resul = 1;
    //Pour chaque pion dans l'odre de dplacment
    for(n = 0; n <= jeu->deplacement; n++)
    {
        for(i = 0; i < jeu->nbr_pions; i++)
        {
            if(jeu->pions[i].joueur == jeu->tour - 1 && jeu->pions[i].type != GRAAL && jeu->pions[i].deplace == n) //S'il appartient au joueur qui vient de finir son tour
            {
                nbr_ennemis = 0;
                //Pour chacune des cases au tour du pion (sauf celle du centre donc)
                for(y = jeu->pions[i].pos_y - 1; y <= jeu->pions[i].pos_y + 1; y++)
                {
                    for(x = jeu->pions[i].pos_x - 1; x <= jeu->pions[i].pos_x + 1; x++)
                    {
                        if(x != jeu->pions[i].pos_x || y != jeu->pions[i].pos_y)
                        {
                            ennemi[nbr_ennemis++] = pion_case(x, y, jeu->pions, jeu->nbr_pions); //On rcupre l'ventuel pion s'y trouvant
                        }
                    }
                }
                nbr_ennemis = classer_ennemi(jeu->pions, ennemi, nbr_ennemis, jeu->tour);
                j = 0;
                while(j < nbr_ennemis)
                {
                    if(combat(jeu, res, i, ennemi[j])) {j++;} //Si on est encore debout, on passe  l'ennemi suivant
                    else //Sinon on abandonne les combats
                    {
                        nbr_ennemis = 0;
                        resul = 0;
                    }
                }
            }
        }
    }
    return resul;
}

long combat(t_partie *jeu, t_reseau *res, long p1, long p2)
{
    char buffer[BUFFER_MAX];
    long resul, p, temp;
    type_pion a, b;

    //Utilisation du type modifi par le graal
    a = jeu->pions[p1].type;
    b = jeu->pions[p2].type;
    if(jeu->pions[p1].graal) {a = ECLAIREUR;}
    if(jeu->pions[p2].graal) {b = ECLAIREUR;}

    //On traite les galits d'abord pour simplifier le travail aprs
    if(a == CHEVALIER && b == CHEVALIER) //Chevalier VS Chevalier : On recule
    {
        reculer(res, jeu, p1);
        reculer(res, jeu, p2);
        exploration(jeu->pions[p1].pos_x, jeu->pions[p1].pos_y, jeu->dist_inc, &(jeu->map), res->joueurs[jeu->pions[p1].joueur].explore);
        exploration(jeu->pions[p2].pos_x, jeu->pions[p2].pos_y, jeu->dist_inc, &(jeu->map), res->joueurs[jeu->pions[p2].joueur].explore);
        SDLNet_Write32(p1, buffer);
        SDLNet_Write32(jeu->pions[p1].pos_x, buffer + 4);
        SDLNet_Write32(jeu->pions[p1].pos_y, buffer + 8);
        for(temp = 0; temp < res->nbr_joueurs; temp++) {communiquer(COMBAT, 12, buffer, res->joueurs[temp]);}
        SDLNet_Write32(p2, buffer);
        SDLNet_Write32(jeu->pions[p2].pos_x, buffer + 4);
        SDLNet_Write32(jeu->pions[p2].pos_y, buffer + 8);
        for(temp = 0; temp < res->nbr_joueurs; temp++) {communiquer(COMBAT, 12, buffer, res->joueurs[temp]);}
        return 0; //Comme on a boug, on arrte les combats
    }
    else if(a == ECLAIREUR && b == ECLAIREUR) {return 1;} //claireur VS claireur : rien ne se passe, suivant !
    else if(a == PECORE && b == PECORE) //Pcore VS Pcore : alatoirement l'un ou l'autre
    {
        if(rand() % 2) {a = ECLAIREUR;}
        else {b = ECLAIREUR;}
    }
    //On traite maintenant les autres cas
    if(((a == ECLAIREUR || a == PECORE) && b == CHEVALIER) || (a == ECLAIREUR && b == PECORE)) //Si on a l'un des 2 seuls cas restants o p2 gagne
    {
        p = p1; //p1 perd
        resul = 0; //il va donc tre renvoy (abandon des combats)
    }
    else
    {
        p = p2; //p1 gagne
        resul = 1; //Il reste sur place et continue les combats
    }
    if(jeu->pions[p].graal) //Si le perdant porte un graal
    {
        temp = graal_pion(jeu->pions[p].graal, jeu->pions, jeu->nbr_pions);
        jeu->pions[temp].graal = 0; //Graal relach
        jeu->pions[p].graal = 0;
        place_libre(jeu->pions[p].pos_x, jeu->pions[p].pos_y, temp, jeu); //Le graal est alors lach au tour du perdant
        exploration(jeu->pions[temp].pos_x, jeu->pions[temp].pos_y, jeu->dist_inc, &(jeu->map), res->joueurs[jeu->pions[temp].joueur].explore);
        SDLNet_Write32(temp, buffer);
        SDLNet_Write32(jeu->pions[temp].pos_x, buffer + 4);
        SDLNet_Write32(jeu->pions[temp].pos_y, buffer + 8);
        for(temp = 0; temp < res->nbr_joueurs; temp++) {communiquer(MODIF_GRAAL, 12, buffer, res->joueurs[temp]);}
    }
    place_libre(res->joueurs[jeu->pions[p].joueur].x, res->joueurs[jeu->pions[p].joueur].y, p, jeu); //Le perdant est renvoy au dpart
    exploration(jeu->pions[p].pos_x, jeu->pions[p].pos_y, jeu->dist_inc, &(jeu->map), res->joueurs[jeu->pions[p].joueur].explore);
    SDLNet_Write32(p, buffer);
    SDLNet_Write32(jeu->pions[p].pos_x, buffer + 4);
    SDLNet_Write32(jeu->pions[p].pos_y, buffer + 8);
    for(temp = 0; temp < res->nbr_joueurs; temp++) {communiquer(COMBAT, 12, buffer, res->joueurs[temp]);}
    return resul;
}

long classer_ennemi(t_pion *pions, long ennemi[8], long nbr_ennemis, long num)
{
    long resul;
    long i, j;
    long temp;

    //On enlve les pions qui ne sont pas des ennemis
    resul = nbr_ennemis;
    i = 0;
    while(i < resul)
    {
        if(ennemi[i] == -1 || num - 1 == pions[ennemi[i]].joueur || pions[ennemi[i]].type == GRAAL)
        {
            resul--;
            for(j = i; j < resul; j++)
            {
                ennemi[j] = ennemi[j + 1];
            }
        }
        else {i++;}
    }
    //On classe ensuite par ordre de rsolution des combats
    for(i = 0; i < resul - 1; i++)
    {
        for(j = 0; j < resul - 1; j++)
        {
            if ((pions[ennemi[j]].type == GRAAL && pions[ennemi[j + 1]].type == GRAAL && pions[ennemi[j]].joueur == num - 1) ||
                (pions[ennemi[j]].type == GRAAL && pions[ennemi[j + 1]].type == CHEVALIER) ||
                (pions[ennemi[j]].type == GRAAL && pions[ennemi[j + 1]].type == PECORE) ||
                (pions[ennemi[j]].type == GRAAL && pions[ennemi[j + 1]].type == ECLAIREUR) ||
                (pions[ennemi[j]].type == CHEVALIER && pions[ennemi[j + 1]].type == PECORE) ||
                (pions[ennemi[j]].type == CHEVALIER && pions[ennemi[j + 1]].type == ECLAIREUR) ||
                (pions[ennemi[j]].type == PECORE && pions[ennemi[j + 1]].type == ECLAIREUR))
            {
                temp = ennemi[j];
                ennemi[j] = ennemi[j + 1];
                ennemi[j + 1] = temp;
            }
        }
    }
    return resul;
}

void distribuer_graal(t_partie *jeu, t_reseau *res)
{
    char buffer[BUFFER_MAX];
    long i, x, y, graal;
    long ennemi[8];
    long nbr_ennemis;

    //Pour chaque joueur
    for (i = 1; i <= res->nbr_joueurs; i++)
    {
        graal = graal_pion(i, jeu->pions, jeu->nbr_pions); //On rcupre son graal
        if(jeu->pions[graal].graal == 0) //S'il n'est pas port
        {
            nbr_ennemis = 0;
            //Pour chacune des cases au tour du pion (sauf celle du centre donc)
            for(y = jeu->pions[graal].pos_y - 1; y <= jeu->pions[graal].pos_y + 1; y++)
            {
                for(x = jeu->pions[graal].pos_x - 1; x <= jeu->pions[graal].pos_x + 1; x++)
                {
                    if(x != jeu->pions[graal].pos_x || y != jeu->pions[graal].pos_y)
                    {
                        ennemi[nbr_ennemis++] = pion_case(x, y, jeu->pions, jeu->nbr_pions); //On rcupre l'ventuel pion s'y trouvant
                    }
                }
            }

            //On compte le nombre de pions au tour
            y = 0;
            while(y < nbr_ennemis)
            {
                if(ennemi[y] == -1 || jeu->pions[ennemi[y]].type == GRAAL || jeu->pions[ennemi[y]].type == ECLAIREUR || jeu->pions[ennemi[y]].graal ||
                (jeu->pions[ennemi[y]].joueur == i - 1 && jeu->pions[graal].pos_x == res->joueurs[i - 1].x && jeu->pions[graal].pos_y == res->joueurs[i - 1].y)) //S'il y a personne ou que c'est un graal ou un claireur ou que le pion porte dj un graal ou (que le graal est  sa position de dpart et le pion appartient  ce joueur)
                {
                    nbr_ennemis--; //On l'enlve des possibilits
                    for(x = y; x < nbr_ennemis - 1; x++)
                    {
                        ennemi[x] = ennemi[x + 1];
                    }
                }
                else {y++;}
            }

            //On le donne  l'un d'eux choisi au hasard
            if(nbr_ennemis) //S'il reste des possibilits
            {
                nbr_ennemis = rand() % nbr_ennemis;
                jeu->pions[ennemi[nbr_ennemis]].graal = jeu->pions[graal].joueur + 1;
                jeu->pions[graal].pos_x = jeu->pions[ennemi[nbr_ennemis]].pos_x;
                jeu->pions[graal].pos_y = jeu->pions[ennemi[nbr_ennemis]].pos_y;
                jeu->pions[graal].graal = jeu->pions[ennemi[nbr_ennemis]].joueur + 1;
                exploration(jeu->pions[graal].pos_x, jeu->pions[graal].pos_y, jeu->dist_inc, &(jeu->map), res->joueurs[jeu->pions[graal].joueur].explore);
                SDLNet_Write32(graal, buffer);
                SDLNet_Write32(ennemi[nbr_ennemis], buffer + 4);
                for(x = 0; x < res->nbr_joueurs; x++) {communiquer(MODIF_GRAAL, 8, buffer, res->joueurs[x]);}
            }
        }
    }
}

long choisir_slot(t_reseau *res, char *pseudo)
{
    long i, j;

    for(i = 0; i < res->nbr_joueurs; i++) //Pour chaque slot
    {
        if(res->pseudo[i] == NULL) //Si libre choix du pseudo
        {
            for(j = i + 1; j < res->nbr_joueurs; j++) //Pour chaque slot restant
            {
                if(res->pseudo[j]) {if(strcmp(res->pseudo[j], pseudo) == 0) {return 0;}} //Si le pseudo est dj utilis, on interdit la rutilisation
            }
            return i + 1;
        }
        else if(strcmp(res->pseudo[i], pseudo) == 0) {return i + 1;} //Ou si le pseudo correspond  un pseudo attendu
    }
    return 0;
}

void swap_slot(t_reseau *res, long a, long b)
{
    t_joueur j;
    char **ct;

    j = res->joueurs[a];
    res->joueurs[a] = res->joueurs[b];
    res->joueurs[b] = j;
    ct = res->joueurs[a].explore;
    res->joueurs[a].explore = res->joueurs[b].explore;
    res->joueurs[b].explore = ct;
    return;
}

long test_victoire(t_partie *jeu, t_reseau *res, long num)
{
    char buffer[BUFFER_MAX];
    long i, j, temp, pion, graal;

    //Pour chaque case au tour de la position de dpart
    graal = 0;
    for(i = res->joueurs[num - 1].y - 1; i <= res->joueurs[num - 1].y + 1; i++)
    {
        for(j = res->joueurs[num - 1].x - 1; j <= res->joueurs[num - 1].x + 1; j++)
        {
            pion = pion_case(j, i, jeu->pions, jeu->nbr_pions);
            if(pion != -1) //S'il y a un pion sur cette case
            {
                if(jeu->pions[pion].joueur == num - 1 && jeu->pions[pion].graal) //Et que ce pion appartient au joueur qui vient de finir son tour et porte un graal
                {
                    if(jeu->pions[pion].graal == num) //Si ce pion porte le graal de son quipe alors il le replace
                    {
                        temp = graal_pion(jeu->pions[pion].graal, jeu->pions, jeu->nbr_pions);
                        jeu->pions[temp].graal = 0;
                        jeu->pions[temp].pos_x = res->joueurs[num - 1].x;
                        jeu->pions[temp].pos_y = res->joueurs[num - 1].y;
                        jeu->pions[pion].graal = 0;
                        SDLNet_Write32(temp, buffer);
                        SDLNet_Write32(jeu->pions[temp].pos_x, buffer + 4);
                        SDLNet_Write32(jeu->pions[temp].pos_y, buffer + 8);
                        for(temp = 0; temp < res->nbr_joueurs; temp++) {communiquer(MODIF_GRAAL, 12, buffer, res->joueurs[temp]);}
                    }
                    else {graal = jeu->pions[pion].graal;}
                }
            }
        }
    }
    pion = pion_case(res->joueurs[num - 1].x, res->joueurs[num - 1].y, jeu->pions, jeu->nbr_pions);
    if(pion != -1)
    {
        if(jeu->pions[pion].type == GRAAL && jeu->pions[pion].joueur == num - 1) {return graal;} //Si le graal est a sa place on renvoie le graal captur (ou 0 si aucun) -> victoire (sauf si 0)
        else {return 0;} //Mme si un graal ennemi est rapport, on ne peut pas gagner si le graal de l'quipe n'est pas  sa place
    }
    else {return 0;}
}

void test_campeur(t_reseau *res, t_partie *jeu, long num)
{
    char buffer[BUFFER_MAX];
    long graal, test, i, j, pion;

    test = 0;
    graal = graal_pion(num, jeu->pions, jeu->nbr_pions);
    if(jeu->pions[graal].pos_x == res->joueurs[num - 1].x && jeu->pions[graal].pos_y == res->joueurs[num - 1].y) //Si le graal est  sa position de dpart
    {
        //Pour chaque case au tour du pion
        for(i = res->joueurs[num - 1].y - 1; i <= res->joueurs[num - 1].y + 1; i++)
        {
            for(j = res->joueurs[num - 1].x - 1; j <= res->joueurs[num - 1].x + 1; j++)
            {
                pion = pion_case(j, i, jeu->pions, jeu->nbr_pions);
                if(pion != -1 && (i != res->joueurs[num - 1].y || j != res->joueurs[num - 1].x)) //S'il y a un pion sur cette case
                {
                    if(jeu->pions[pion].joueur == num - 1) {test = 1;} //Si ce pion lui appartient
                }
            }
        }
    }
    if(test == 0) {res->joueurs[num - 1].campeur = 0;} //Si le joueur ne campe pas
    else //S'il campe
    {
        if(res->joueurs[num - 1].campeur == 0) //mais que c'est le dbut de son tour
        {
            res->joueurs[num - 1].campeur = 1; //Il devra partir avant la fin de son tour
            envoyer_message("Attention, si vos pions restent au tour du graal, il sera tlport.", res->joueurs[num - 1]);
        }
        else //Sinon, on tlporte le graal ailleurs
        {
            place_libre(rand() % jeu->map.largeur, rand() % jeu->map.hauteur, graal, jeu);
            SDLNet_Write32(graal, buffer);
            SDLNet_Write32(jeu->pions[graal].pos_x, buffer + 4);
            SDLNet_Write32(jeu->pions[graal].pos_y, buffer + 8);
            for(i = 0; i < res->nbr_joueurs; i++) {communiquer(MODIF_GRAAL, 12, buffer, res->joueurs[i]);}
            exploration(jeu->pions[graal].pos_x, jeu->pions[graal].pos_y, jeu->dist_inc, &(jeu->map), res->joueurs[num - 1].explore);
            res->joueurs[num - 1].campeur = 0;
        }
    }
}

long sauvegarder(t_affichage *aff, t_reseau *res, t_partie *jeu, char *nom)
{
    FILE *fichier;
    long i, j;
    char temp[BUFFER_MAX];

    sprintf(temp, "%s%s", SAVES_DIR, nom);
    fichier = fopen(temp, "wb");
    if(!fichier)
    {
        sprintf(temp, "Impossible de sauvegarder dans %s !", nom);
        afficher_message(aff->ecran, temp, aff->police_normale, 255, 0, 0);
        return 0;
    }
    fwrite("KJEU", 1, 4, fichier); //Caractres d'identification

    //Infos
    SDLNet_Write32(res->nbr_joueurs, temp); //Nombre de joueurs
    fwrite(temp, 4, 1, fichier);
    SDLNet_Write32(jeu->nbr_pions, temp); //Nombre de pions
    fwrite(temp, 4, 1, fichier);
    SDLNet_Write32(jeu->tour, temp); //Numro du tour
    fwrite(temp, 4, 1, fichier);
    SDLNet_Write32(jeu->deplacement, temp); //Nombre de dplacements  ce tour
    fwrite(temp, 4, 1, fichier);
    SDLNet_Write32(jeu->dist_inc, temp); //Distance de dcouverte du terrain
    fwrite(temp, 4, 1, fichier);
    SDLNet_Write32(jeu->dist_vis, temp); //Distance de visibilit
    fwrite(temp, 4, 1, fichier);

    //Terrain
    SDLNet_Write32(jeu->map.taille, temp); //Taille du fichier map
    fwrite(temp, 4, 1, fichier);
    SDLNet_Write32(jeu->map.tileset.taille, temp); //Taille du fichier tileset
    fwrite(temp, 4, 1, fichier);
    fwrite(jeu->map.fichier, 1, jeu->map.taille, fichier); //criture du fichier map
    fwrite(jeu->map.tileset.fichier, 1, jeu->map.tileset.taille, fichier); //criture du fichier tileset

    //Joueurs
    for(i = 0; i < res->nbr_joueurs; i++) //Pour chaque joueur
    {
        SDLNet_Write32(res->joueurs[i].x, temp); //Position de dpart
        fwrite(temp, 4, 1, fichier);
        SDLNet_Write32(res->joueurs[i].y, temp);
        fwrite(temp, 4, 1, fichier);
        SDLNet_Write32(strlen(res->pseudo[i]) + 1, temp); //taille du pseudo
        fwrite(temp, 4, 1, fichier);
        fputs(res->pseudo[i], fichier); //Pseudo + caractre nul
        fputc(0, fichier);
        for(j = 0; j < jeu->map.hauteur; j++) {fwrite(res->joueurs[i].explore[j], 1, jeu->map.largeur, fichier);} //Terrain exlor
    }

    //Pions
    for(i = 0; i < jeu->nbr_pions; i++) //Pour chaque pion
    {
        SDLNet_Write32(jeu->pions[i].joueur, temp); //Joueur  qui il appartient
        fwrite(temp, 4, 1, fichier);
        SDLNet_Write32((long) jeu->pions[i].type, temp); //Type du pion (CHEVALIER, etc.)
        fwrite(temp, 4, 1, fichier);
        SDLNet_Write32(jeu->pions[i].pos_x, temp); //position
        fwrite(temp, 4, 1, fichier);
        SDLNet_Write32(jeu->pions[i].pos_y, temp);
        fwrite(temp, 4, 1, fichier);
        SDLNet_Write32(jeu->pions[i].pts, temp); //Points de mouvement
        fwrite(temp, 4, 1, fichier);
        SDLNet_Write32(jeu->pions[i].pts_max, temp);
        fwrite(temp, 4, 1, fichier);
        SDLNet_Write32(jeu->pions[i].graal, temp); //Le joueur dont il porte le graal (si c'est le cas)
        fwrite(temp, 4, 1, fichier);
        SDLNet_Write32(jeu->pions[i].deplace, temp); //Numro du dplacement
        fwrite(temp, 4, 1, fichier);
    }

    fclose(fichier);
    sprintf(temp, "Partie sauvegarde dans %s !", nom);
    afficher_message(aff->ecran, temp, aff->police_normale, 0, 255, 0);
    return 1;
}

long charger(t_affichage *aff, t_reseau *res, t_partie *jeu, char *nom)
{
    FILE *fichier, *ft1 = NULL, *ft2 = NULL;
    long i, j;
    char temp[BUFFER_MAX], fn1[L_tmpnam + sizeof(MAPS_DIR)] = MAPS_DIR, fn2[L_tmpnam + sizeof(RESSOURCES_DIR)] = RESSOURCES_DIR;

    if(res->chargee) {free(jeu->pions);}
    res->chargee = 0;
    if(jeu->map_chargee) {supprimer_map(res, &(jeu->map));}
    jeu->map_chargee = 0;

    sprintf(temp, "%s%s", SAVES_DIR, nom);
    fichier = fopen(temp, "rb");
    tmpnam(fn1 + sizeof(MAPS_DIR) - 1);
    fn1[sizeof(MAPS_DIR) - 1] = '_';
    ft1 = fopen(fn1, "wb");
    tmpnam(fn2 + sizeof(RESSOURCES_DIR) - 1);
    fn2[sizeof(RESSOURCES_DIR) - 1] = '_';
    ft2 = fopen(fn2, "wb");
    if(!fichier || !ft1 || !ft2)
    {
        if(!fichier) {fclose(fichier);}
        if(!ft1) {fclose(ft1);}
        if(!ft2) {fclose(ft2);}
        sprintf(temp, "Impossible de charger depuis %s !", nom);
        afficher_message(aff->ecran, temp, aff->police_normale, 255, 0, 0);
        return 0;
    }
    fread(temp, 1, 4, fichier); //Caractres d'identification
    temp[4] = 0;
    if(strcmp(temp, "KJEU") != 0)
    {
        sprintf(temp, "%s n'est pas une sauvegarde du jeu !", nom);
        afficher_message(aff->ecran, temp, aff->police_normale, 255, 0, 0);
        return 0;
    }

    //Infos
    fread(temp, 4, 1, fichier); //Nombre de joueurs (ignor car le chargement de la map le mettra  jour)
    fread(temp, 4, 1, fichier);
    jeu->nbr_pions = SDLNet_Read32(temp); //Nombre de pions
    fread(temp, 4, 1, fichier);
    jeu->tour = SDLNet_Read32(temp); //Numro du tour
    fread(temp, 4, 1, fichier);
    jeu->deplacement = SDLNet_Read32(temp); //Nombre de dplacements  ce tour
    fread(temp, 4, 1, fichier);
    jeu->dist_inc = SDLNet_Read32(temp); //Distance de dcouverte du terrain
    fread(temp, 4, 1, fichier);
    jeu->dist_vis = SDLNet_Read32(temp); //Distance de visibilit

    //Terrains
    fread(temp, 4, 1, fichier);
    jeu->map.taille = SDLNet_Read32(temp); //Taille du fichier map
    fread(temp, 4, 1, fichier);
    jeu->map.tileset.taille = SDLNet_Read32(temp); //Taille du fichier tileset

    for(i = 0; i < jeu->map.taille; i++)
    {
        fread(temp, 1, 1, fichier);
        fwrite(temp, 1, 1, ft1);
    }
    fclose(ft1);
    for(i = 0; i < jeu->map.tileset.taille; i++)
    {
        fread(temp, 1, 1, fichier);
        fwrite(temp, 1, 1, ft2);
    }
    fclose(ft2);
    if(!charger_map(res, &(jeu->map), fn1 + sizeof(MAPS_DIR) - 1, fn2 + sizeof(RESSOURCES_DIR) - 1))
    {
        jeu->nbr_pions = 0;
        fclose(fichier);
        sprintf(temp, "%s est corrompu !", nom);
        afficher_message(aff->ecran, temp, aff->police_normale, 255, 0, 0);
        return 0;
    }
    remove(fn1);
    remove(fn2);
    jeu->map_chargee = 1;

    //Joueurs
    for(i = 0; i < res->nbr_joueurs; i++) //Pour chaque joueur
    {
        fread(temp, 4, 1, fichier);
        res->joueurs[i].x = SDLNet_Read32(temp); //Position de dpart
        fread(temp, 4, 1, fichier);
        res->joueurs[i].y = SDLNet_Read32(temp);
        fread(temp, 4, 1, fichier);
        j = SDLNet_Read32(temp); //taille du pseudo
        res->pseudo[i] = (char *)malloc(j * sizeof(char));
        fgets(res->pseudo[i], j, fichier); //Pseudo
        fgetc(fichier); //caractre nul
        for(j = 0; j < jeu->map.hauteur; j++) {fread(res->joueurs[i].explore[j], 1, jeu->map.largeur, fichier);} //Terrain exlor
    }

    jeu->pions = (t_pion *)malloc(jeu->nbr_pions * sizeof(t_pion));
    if(!jeu->pions)
    {
        jeu->nbr_pions = 0;
        fclose(fichier);
        printf(temp, "Impossible d'allouer la mmoire pour les pions !", nom);
        afficher_message(aff->ecran, temp, aff->police_normale, 255, 0, 0);
        return 0;
    }
    //Pions
    for(i = 0; i < jeu->nbr_pions; i++) //Pour chaque pion
    {
        fread(temp, 4, 1, fichier);
        jeu->pions[i].joueur = SDLNet_Read32(temp); //Joueur  qui il appartient
        fread(temp, 4, 1, fichier);
        jeu->pions[i].type = SDLNet_Read32(temp); //Type du pion (CHEVALIER, etc.)
        fread(temp, 4, 1, fichier);
        jeu->pions[i].pos_x = SDLNet_Read32(temp); //position
        fread(temp, 4, 1, fichier);
        jeu->pions[i].pos_y = SDLNet_Read32(temp);
        fread(temp, 4, 1, fichier);
        jeu->pions[i].pts = SDLNet_Read32(temp); //Points de mouvement
        fread(temp, 4, 1, fichier);
        jeu->pions[i].pts_max = SDLNet_Read32(temp);
        fread(temp, 4, 1, fichier);
        jeu->pions[i].graal = SDLNet_Read32(temp); //Le joueur dont il porte le graal (si c'est le cas)
        fread(temp, 4, 1, fichier);
        jeu->pions[i].deplace = SDLNet_Read32(temp); //Numro du dplacement
    }

    res->chargee = 1;
    fclose(fichier);
    sprintf(temp, "Partie charge depuis %s !", nom);
    afficher_message(aff->ecran, temp, aff->police_normale, 0, 255, 0);
    return 1;
}
